/**
  Copyright (c) 2009 Freescale Semiconductor
  
  \file  	  Display.h
  \brief	  This is the Display driver header File
  \brief	  Provides functionality control the display layers
  \author	  Freescale Semiconductor
  \author	  Automotive Systems Solutions Engineering
  \author	  IM, b06623
  \version	  2.0
  \revision	  $Revision: 21 $
  \date  	  $Date: 2010-09-09 19:26:09 -0500 (Thu, 09 Sep 2010) $  
  
  
  * History:  11/May/2009 - Initial Version
  			  25/May/2010 - Update Version, support to DCU lite and DC3.
  			  25/Ago/2010 - Added prototype Display_UpdateClutDMA_cb to deprecate define for Display_UpdateClutDMA_e

* Copyright (c) 2009, Freescale, Inc.  All rights reserved.
*
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
*
  
*/


#ifndef 	_DISPLAY_H_
#define  	_DISPLAY_H_	 

#include     "DCU_drv.h"
#include	 "Graphics.h"

/******************************* Data Types **********************************/

typedef  void  ( * Display_CallbackType )( void  );

/* Display Error Type */
typedef  enum
{
	DISPLAY_ERROR_OK,	/**< Succesful operation */
	DISPLAY_ERROR_DMA,	/**< DMA related error */
	DISPLAY_ERROR_SIZE	/**< PARAM related error */
} Display_Error_t;

/******************************* Functions prototypes **********************************/

void Display_InitLayer(uint8_t layer, Graphics_Object_t* g_object, uint16_t x, uint16_t y);

void Display_UpdateClut(Graphics_Object_t *g_object);
void Display_SaveLayerContext(uint8_t layer, DCU_LAYER_tag *local_layer);
void Display_RestoreLayerContext(uint8_t layer, DCU_LAYER_tag *local_layer);
Display_Error_t Display_UpdateClutDMA(uint8_t eDMAChannel, Graphics_Object_t *g_object);
/* DEPRECATED, will be removed in future releases */
#ifndef REMOVE_DEPRECATED
Display_Error_t Display_UpdateClutDMA_e(uint8_t eDMAChannel, Graphics_Object_t *g_objectArray[], uint8_t size);
#endif
Display_Error_t Display_UpdateClutDMA_cb(uint8_t eDMAChannel, Graphics_Object_t *g_object, Display_CallbackType cb);
Display_Error_t Display_HWCursorInit
(
	uint8_t  eDMAChannel,
	uint16_t width,
	uint16_t height,
	uint16_t x,
	uint16_t y,
	uint32_t color,
	uint32_t* bitmap
);

/********************* Public Macros Function-alike **************************/

#define Display_SelectDCU()						DCU_SelectDCU(DCU_DCU);\
												GALLO_SetContextDCU()
												
#define Display_SelectDCULITE()					DCU_SelectDCU(DCU_DCULITE);\
												GALLO_SetContextDCULITE()

#define	Display_On()							DCU_Enable()
#define Display_LayerEnable( layer )			DCU_LayerEnable( layer )
#define Display_LayerDisable( layer ) 			DCU_LayerDisable( layer )
#define Display_LayerIsEnabled( layer )	 		DCU_LayerIsEnabled( layer )
#define Display_SetAlpha( layer )			DCU_LayerAlpha( layer )	
#define Display_RefreshAddress(layer, object)	        DCU_LayerAddress(layer) = (object).address
#define Display_LayerSetAddress(layer, address)	        DCU_LayerAddress(layer) = (address)
#define Display_LayerGetAddress(layer)	                DCU_LayerAddress(layer)                                                                                                  
#define Display_SetTextMode( layer )			DCU_LayerChromaCfg( (layer) ) = DCU_CHROMMA_ON; \
	    										DCU_LayerAlphaCfg( (layer) ) = DCU_ALPHAALL_ON			
#define Display_SetChromaOn( layer )			DCU_LayerChromaCfg( layer ) = DCU_CHROMMA_ON
#define Display_SetChromaOff( layer )			DCU_LayerChromaCfg( layer ) = DCU_CHROMMA_OFF
#define Display_SetAlphaAllOn( layer )			DCU_LayerAlphaCfg( layer ) = DCU_ALPHAALL_ON
#define Display_SetAlphaOff( layer )			DCU_LayerAlphaCfg( layer ) = DCU_ALPHA_OFF
#define Display_SetAlphaChromaOn( layer )		DCU_LayerAlphaCfg( layer ) = DCU_ALPHACHROMMA_ON
#define Display_FGColor(layer)					DCU_ForeGroundColor((layer))
#define Display_BGColor(layer)					DCU_BackGroundColor((layer))

#define	Display_HWCursorDeInit( )				DCU_HWCursorDisable( )
#define	Display_HWCursorSetY( value )			DCU_HWCursorY() = (value)
#define	Display_HWCursorSetX( value )			DCU_HWCursorX() = (value) 
#define	Display_HWCursorBlinkDis( )				DCU_HWCursorBlinkDis( )
#define	Display_HWCursorBlink( value )			DCU_HWCursorBlinkEn( ); \
                                        		DCU_HWCursorBlinkVal(value)

#endif //#ifndef 	_DISPLAY_H_